(*
 -------------------------------------------------------------------------
 Copyright (C) 1998-2003 Hger+Busch                   / >>>>>>>>> /-----
 Ingenieurbuero fuer Kommunikationslsungen           / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
 All rights reserved. http://www.commso.com

 Project     : hbTapi Components
 Link        : http://www.commso.com
 Modul       : Sample
 Version     : 1.0
 Description : This sample shows how determine line device capabillities.

 History     : [-] Fixed [+] Added [*] Improved

 01/01/03   Creation
*)
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls,
  hbTapi, hbTapiUtils, Tapi, ExtCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    TapiLine1: TTapiLine;
    TapiPhone1: TTapiPhone;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure DetectRelatedDevice;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DetectRelatedDevice;
var i: integer;
begin
  try
    TapiLine1.Active := True;
  except
    on E:ETapiError do
    begin
      Memo1.Lines.Add('  Error opening device = ' + E.Message);
      exit;
    end;
  end;

  if TapiLine1.Phones.Count = 0 then
    Memo1.Lines.Add('  TAPI Phone Device = n/a')
  else
  begin
    for i := 0 to TapiLine1.Phones.Count -1 do
    begin
      TapiPhone1.DeviceID := TapiLine1.Phones.DeviceID[i];
      Memo1.Lines.Add('  TAPI Phone Device ID = ' + IntToStr(TapiPhone1.DeviceID));
      Memo1.Lines.Add('  TAPI Phone Device Name = ' + TapiPhone1.DeviceName);
    end;
  end;

  if not TapiLine1.WaveOut.Available then
    Memo1.Lines.Add('  Wave Play Device = n/a')
  else
    Memo1.Lines.Add('  Wave Play Device ID = ' + IntToStr(TapiLine1.WaveOut.DeviceID));

  if not TapiLine1.WaveIn.Available then
    Memo1.Lines.Add('  Wave Record Device = n/a')
  else
    Memo1.Lines.Add('  Wave Record Device ID = ' + IntToStr(TapiLine1.WaveIn.DeviceID));
  TapiLine1.Active := False;
end;

procedure TForm1.Button1Click(Sender: TObject);
  var i:  Integer;
begin
  Memo1.Lines.Clear;
  for i := 0 to TapiLine1.DeviceList.Count - 1 do
  begin
    TapiLine1.DeviceID := i;
    Memo1.Lines.Add(Format('Device #%d - %s', [i, TapiLine1.DeviceName]));
    if TapiLine1.Available then
    begin
      Memo1.Lines.Add(Format('  MediaModes : %s', [LineMediaModesToStr(TapiLine1.Caps.MediaModes)]));
      Memo1.Lines.Add(Format('  BearerModes: %s', [LineBearerModesToStr(TapiLine1.Caps.BearerModes)]));
      DetectRelatedDevice;
    end;
    Memo1.Lines.Add('');
  end;
  if Memo1.Lines.Count = 0 then
    Memo1.Lines.Add('No devices found');
end;

end.
